﻿using System;

namespace Framework
{
    /// <summary>
    /// TimeSpan の拡張メソッドです。
    /// </summary>
    public static class TimeSpanExtension
    {
        public static DateTime Ago(this TimeSpan target, DateTime time)
        {
            return time - target;
        }

        public static DateTime Ago(this TimeSpan target)
        {
            return target.Ago(DateTime.Now);
        }

        public static DateTime Since(this TimeSpan target, DateTime time)
        {
            return time + target;
        }

        public static DateTime Since(this TimeSpan target)
        {
            return target.Since(DateTime.Now);
        }

        public static DateTime FromNow(this TimeSpan target)
        {
            return target.Since(DateTime.Now);
        }
    }
}
